<?php

session_start();

require_once "../controladores/ventas.controlador.php";
require_once "../modelos/ventas.modelo.php";

require_once "../controladores/clientes.controlador.php";
require_once "../modelos/clientes.modelo.php";


require_once "../controladores/usuarios.controlador.php";
require_once "../modelos/usuarios.modelo.php";



class TablaVentasServer
{

static function mostrarTablaVentasServer()
{

    $item = null;
    $valor = null;

    if(isset($_GET["between1"])){

        $between1 = $_GET["between1"];
        $between2 = $_GET["between2"];
    

      }else{

        $between1 = null;
        $between2 = null;
    

      }


    $venta = ControladorVentas::ctrRangoFechasVentasServer($item, $valor, $between1, $between2);

  
    $ventaArray = $venta["data"];

    if(count($ventaArray) == 0) {
        echo '{"draw":0, "iTotalRecords":0,"iTotalDisplayRecords":0,"data":[]}';
        return;
    }
    

    $datosJson = '{
    "draw" : ' . $venta["draw"] . ',
    "iTotalRecords" :   ' . $venta["iTotalRecords"] . ',
    "iTotalDisplayRecords" :  ' . $venta["iTotalDisplayRecords"] . ',
    "data" : [';

    
    foreach ($ventaArray as $key => $value) {
        $datosJson .= '{
          
            "id":       "' . $value["id"] . '",
            "codigo":       "' . $value["codigo"] . '",
            "id_cliente":  "' .  $value["id_cliente"] . '",
            "total_pendiente_pago":  "$ ' .number_format($value["total_pendiente_pago"],0,  '', '.') . '",
            "total":  "$ ' .number_format($value["total"],0,  '', '.') . '",
            "fecha":  "' . date("d-m-Y | H:i:s", strtotime($value["fecha"])) . '",
            "descuento":  "$ ' .number_format($value["descuento"],0,  '', '.') . '",
            "total_pagado":  "$ ' .number_format($value["total_pagado"],0,  '', '.') . '",
            "id_vendedor":  "' . $value["id_vendedor"]  . '"
          
         
        },';
    }

    $datosJson = substr($datosJson, 0, -1);

    $datosJson .= ']
    }';

    echo $datosJson;

    }
}



$activarVentas = new TablaVentasServer();
$activarVentas->mostrarTablaVentasServer();