$(function(){
    var $nuevo = $("#formVenta");
    $.validator.addMethod("noSpace", function(value, element){
        return value == '' || value.trim().length != 0
    }, "No Hagas Espacios");

    jQuery.validator.addMethod("validarPago", function(value, element) { 
        return this.optional( element ) || /^[0-9]+$/.test( value ); 
      }, "Por Favor Ingresar un monto Válido!");


      jQuery.validator.addMethod("validarCodigo", function(value, element) { 
        return this.optional( element ) || /^[0-9]+$/.test( value ); 
      }, "Debe Ingresar un Código Válido!");


      jQuery.validator.addMethod("validarDesc", function(value, element) { 
        return this.optional( element ) || /^[0-9]+$/.test( value ); 
      }, "Debe Ingresar un Número Válido!");

    if($nuevo.length){
        $nuevo.validate({
            rules:{
            TotalPagado:{
                    required: true,
                    noSpace: true,
                    validarPago: true
                },

                TotalPendientePago:{
                    required: true,
                    validarPago: true
                },

                seleccionarCliente:{
                    required: true
                },

                nuevaVenta:{
                    required: true,
                    noSpace: true,
                    validarCodigo: true
                },

                nuevoDescuentoVenta:{
                    required: true,
                    noSpace: true,
                    validarDesc: true

                },
                
                 nuevoTotalVenta:{
                    required: true
                },

                nuevoMetodoPago:{
                    required: true
                }
            },
            messages:{
            TotalPagado:{
                 required: 'Debe Ingresar un Monto!'
             },

             seleccionarCliente:{
                 required: 'Debe Seleccionar un Cliente!'
             },

             nuevaVenta:{
                 required: 'Debe Ingresar un Código'
             },
             nuevoDescuentoVenta:{
                 required: 'Agregue Un Descuento Sino dejar en 0'
             },
             
                nuevoTotalVenta:{
                 required: 'Total Requerido'
             },
             
             TotalPendientePago:{
                 required: 'Debe Ingresar un Monto!'
             },
             nuevoMetodoPago:{
                 required: 'Debe Seleccionar una Opción'
             }

            },



            submitHandler: function (){
           
               
                $.ajax({
                 type: "POST",
                 url: "vistas/modulos/recibir.php",
                 data: $("#formVenta").serialize(),
                 success: function( data ) {
                   //alert(data);
                   //$("#dv_resultado").html( data );
                    $("#dv_resultado").html( data );
                     }
         })
         
                
       }



       })  
     }
 })






